//Lab 2 : Plot the time response of second-order system with real poles
// and compare it with responses of it's individual poles.
//------------------------------------------------------------------
// Problem Statement: Plot the time response of
//G=1/(2s+1)/(3s+1)) and comapare it with responses of
// G1=1/(2s+1) and G2=1/(3s+1))
//------------------------------------------------------------------

//------------------------------------------------------------------
// Operating System OSX (Mac) 10.14.6
// Scilab Version 6.1.0
//------------------------------------------------------------------

xdel(winsid()) // close the figure windows
clear; // clear the workspace
clc; // clear the console
//------------------------------------------------------------------
// system representation

s=%s  //Laplace operator

//system with various time constants.

G=syslin('c',1/(2*s+1)/(3*s+1))    // representation of original system G(s)=1/(2s+1)/(3s+1)

G1=syslin('c',1/(2*s+1))           // G1(s)=1/(2s+1)
G2=syslin('c',1/(3*s+1))           // G2(s)=1/(3s+1)

//------------------------------------------------------------------
// Unit step response

t=0:0.2:30            // Simulation time
dim=size(t);
u=ones(dim(1),dim(2)) // unit step input

c=csim(u,t,G)  // Response of system G

c1=csim(u,t,G1)  // Response of system G1
c2=csim(u,t,G2)  // Response of system G2

//plot 
plot(t,c,t,c1,t,c2,'LineWidth',2)

xgrid

//Title, labels and grid to the figure
legend('System G (SO)','System G1(FO)', 'System G2(FO)',4)
title('Responses of second-order system and its first-order poles' ,'fontsize',2)
xlabel('Time t (sec.)','fontsize',2)
ylabel('c(t)','fontsize',2)
